/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.monsters.thecity;

import com.megacrit.cardcrawl.actions.AbstractGameAction;
import com.megacrit.cardcrawl.actions.animations.AnimateSlowAttackAction;
import com.megacrit.cardcrawl.actions.common.ApplyPowerAction;
import com.megacrit.cardcrawl.actions.common.DamageAction;
import com.megacrit.cardcrawl.actions.common.GainBlockAction;
import com.megacrit.cardcrawl.actions.common.SetMoveAction;
import com.megacrit.cardcrawl.cards.DamageInfo;
import com.megacrit.cardcrawl.core.AbstractCreature;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.localization.MonsterStrings;
import com.megacrit.cardcrawl.monsters.AbstractMonster;
import com.megacrit.cardcrawl.powers.DexterityPower;

public class BanditBear
extends AbstractMonster {
    public static final String ID = "BanditBear";
    private static final MonsterStrings monsterStrings = CardCrawlGame.languagePack.getMonsterStrings("BanditBear");
    public static final String NAME = BanditBear.monsterStrings.NAME;
    public static final String[] MOVES = BanditBear.monsterStrings.MOVES;
    public static final String[] DIALOG = BanditBear.monsterStrings.DIALOG;
    private static final int MAUL_DAMAGE = 18;
    private static final int LUNGE_DAMAGE = 9;
    private static final int LUNGE_DEFENSE = 9;
    private static final int CON_AMT = -2;
    private static final byte MAUL = 1;
    private static final byte BEAR_HUG = 2;
    private static final byte LUNGE = 3;

    public BanditBear(float x, float y) {
        super(NAME, ID, 40, 0.0f, 0.0f, 180.0f, 200.0f, "images/monsters/theCity/fatBandit.png", x, y);
        this.title = "Red Mask Grunt";
        this.damage.add(new DamageInfo(this, 18));
        this.damage.add(new DamageInfo(this, 9));
    }

    @Override
    public void takeTurn() {
        switch (this.nextMove) {
            case 2: {
                AbstractDungeon.actionManager.addToBottom(new AnimateSlowAttackAction(this));
                AbstractDungeon.actionManager.addToBottom(new ApplyPowerAction(AbstractDungeon.player, this, new DexterityPower(AbstractDungeon.player, -2), -2));
                AbstractDungeon.actionManager.addToBottom(new SetMoveAction((AbstractMonster)this, 3, AbstractMonster.Intent.ATTACK_DEFEND, 9));
                break;
            }
            case 1: {
                AbstractDungeon.actionManager.addToBottom(new AnimateSlowAttackAction(this));
                AbstractDungeon.actionManager.addToBottom(new DamageAction((AbstractCreature)AbstractDungeon.player, (DamageInfo)this.damage.get(0), AbstractGameAction.AttackEffect.BLUNT_HEAVY));
                AbstractDungeon.actionManager.addToBottom(new SetMoveAction((AbstractMonster)this, 3, AbstractMonster.Intent.ATTACK_DEFEND, 9));
                break;
            }
            case 3: {
                AbstractDungeon.actionManager.addToBottom(new AnimateSlowAttackAction(this));
                AbstractDungeon.actionManager.addToBottom(new DamageAction((AbstractCreature)AbstractDungeon.player, (DamageInfo)this.damage.get(1), AbstractGameAction.AttackEffect.SLASH_DIAGONAL));
                AbstractDungeon.actionManager.addToBottom(new GainBlockAction(this, this, 9));
                AbstractDungeon.actionManager.addToBottom(new SetMoveAction((AbstractMonster)this, 1, AbstractMonster.Intent.ATTACK, 18));
                break;
            }
        }
    }

    @Override
    public void die() {
        super.die();
        for (AbstractMonster m : AbstractDungeon.getCurrRoom().monsters.monsters) {
            if (m.isDead || m.isDying) continue;
            m.deathReact();
        }
    }

    @Override
    protected void getMove(int num) {
        this.setMove((byte)2, AbstractMonster.Intent.STRONG_DEBUFF);
    }
}

